/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"

vm_cmd_arg vm_all_params[] = {
  {WSTR('h'), WSTR("help"), WSTR(""), WSTR("Show this help screen.")},
  {WSTR('w'), WSTR("words"), WSTR(""), WSTR("Set truncation units to words.")}
};

uint vm_all_param_count=2;

#define INPUT_STREAM 0
#define OUTPUT_STREAM 1

template<typename T> T read();
template<typename T> void write(T c);

template<> char read<char>()
{
  char c;
  int count=read(INPUT_STREAM, &c, sizeof(c));
  if (count == -1)
    {
      perror("read(stdin)");
      exit(1);
    }
  if (count==0)
    exit(0);
  return c;
}

template<> short read<short>()
{
  short c;
  int count=read(INPUT_STREAM, &c, sizeof(c));
  if (count == -1)
    {
      perror("read(stdin)");
      exit(1);
    }
  if (count <2)
    exit(0);
  return c;
}

template<> void write<char>(char c)
{
  if (write(OUTPUT_STREAM, &c, sizeof(c)) == -1)
    {
      perror("write(stdout)");
      exit(1);
    }
}

template<> void write<short>(short c)
{
  if (write(OUTPUT_STREAM, &c, sizeof(c)) == -1)
    {
      perror("write(stdout)");
      exit(1);
    }
}

template<typename T> void run()
{
  T c;
  do {
    c=read<T>();
  } while(c==0);
  while(1)
    {
      write<T>(c);
      int k=-1;
      do {
	c=read<T>();
	k++;
      } while(c==0);
      for(;k>0;k--)
	write<T>(0);
    } // while(1);
}

using namespace std;

int main(int argc, char *argv[])
{
  if (!primary_init())
    return 1;
  if (!parse_cmd_line(argc, argv))
    return 1;
  if (is_used_cmd_param(WSTR("help")))
    {
      cout << "Utility to filter blank gaps in I/O streams." << endl;
      cout << "This utility is part of the VOICEMAN speech system." << endl;
      cout << "There are following command line options:" << endl;
      print_cmd_args_help();
      return 0;
    }
  if (is_used_cmd_param(WSTR("words")))
    run<short>(); else
      run<char>();
  return 0;
}
