/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __CMDLINE_H__
#define __CMDLINE_H__

struct vm_cmd_arg
{
  vm_char short_name;
  vm_char *long_name;
  vm_char *param;
  vm_char *descr;
};

void print_cmd_args_help();
bool is_used_cmd_param(const vm_string &name);
vm_string get_cmd_param_value(const vm_string &name);
bool parse_cmd_line(int argc, char *argv[]);

#endif //__CMDLINE_H__
