/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __LOGGING_H__
#define __LOGGING_H__

class vm_info {};
class vm_warn {};
class vm_error {};
class vm_fatal {};
class vm_endl {};

class vm_log
{
public:
  vm_log(): m_stream(NULL) {};
  virtual ~vm_log() {close();};
  void begin();
  void close();
  vm_log &operator <<(int n);
  vm_log &operator <<(uint n);
  vm_log &operator <<(const char *s);
  vm_log &operator <<(const vm_string &s);
  vm_log &operator <<(const vm_info &c);
  vm_log &operator <<(const vm_warn &c);
  vm_log &operator <<(const vm_error &c);
  vm_log &operator <<(const vm_fatal &c);
  vm_log &operator <<(const vm_endl &c);
private:
  vm_ostringstream *m_stream;
};

extern vm_log vmlog;
extern vm_info vminfo;
extern vm_warn vmwarn;
extern vm_error vmerror;
extern vm_fatal vmfatal;
extern vm_endl vmendl;

#ifndef VOICEMAN_DEBUG
void vm_stop(const vm_char *msg);
void vm_sys_stop(const vm_char *msg);
void vm_sys_warn(const vm_char *msg);
#define VM_STOP(msg) vm_stop(WSTR(msg));
#define VM_SYS_STOP(msg) vm_sys_stop(WSTR(msg));
#define VM_SYS_WARN(msg) vm_sys_warn(WSTR(msg))
#define VM_TRACE(x)
#else
void vm_stop(const vm_char *msg, const char *file, int line);
void vm_sys_stop(const vm_char *msg, const char *file, int line);
void vm_sys_warn(const vm_char *msg, const char *file, int line);
#define VM_STOP(msg) vm_stop(WSTR(msg), __FILE__, __LINE__)
#define VM_SYS_STOP(msg) vm_sys_stop(WSTR(msg), __FILE__, __LINE__)
#define VM_SYS_WARN(msg) vm_sys_warn(WSTR(msg), __FILE__, __LINE__)
#define VM_TRACE(x) std::cout << x << std::endl;
#endif // VOICEMAN_DEBUG

#define VM_SYS(expr, msg) if (!(expr)) VM_SYS_STOP(msg)

extern vm_string config_log_file_name;
extern bool config_log_stderr;
extern bool config_log_info;

#endif //__LOGGING_H__
