/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __SOCKETS_H__
#define __SOCKETS_H__

typedef long vm_ip_addr;

class vm_socket : public vm_class
{
public:
  typedef vm_ptr<vm_socket> ptr;
  vm_socket() : m_sock(0), m_opened(0) {};
  virtual ~vm_socket() {close();};

  int read(void *buf, int s);
  int write(const void *buf, int s);
  bool read(string &s);
  void write(const string &s);
  virtual void close();
  int get_fd() const;
  bool opened() const {return m_opened;};

protected:
  int m_sock;
  bool m_opened;
};

class vm_unix_socket : public vm_socket
{
public:
  typedef vm_ptr<vm_unix_socket> ptr;
  vm_unix_socket() {};
  virtual ~vm_unix_socket() {};
  bool open(const string &name);
};

class vm_inet_socket : public vm_socket
{
public:
  typedef vm_ptr<vm_inet_socket> ptr;
  vm_inet_socket() {};
  virtual ~vm_inet_socket() {};

  bool open(uint port);
};

#endif // __SOCKETS_H__
