/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VMPARAM_H__
#define __VMPARAM_H__

class vm_param
{
public:
  vm_param() : m_value(0.5) {};

  float get_value(float min, float max) const
  {
    if (m_value < 0)
      return min;
    if (m_value > 1)
      return max;
    float d=max-min;
    return min+(d*m_value);
  }

  void increase(float step=0.5)
  {
    if (step < 0)
      return;
    if (step>1)
      {
	m_value=1;
	return;
      }
    float d=1-m_value;
    m_value+=step*d;
  }

  void decrease(float step=0.5)
  {
    if (step<0)
      return;
    if (step > 1)
      {
	m_value=0;
	return;
      }
    float d=m_value;
    m_value-=step*d;
  }

  float get_value() const {return m_value;}
  void set_value(float f)
  {
    if (f < 0)
      m_value=0; else
	if (f> 1)
	  m_value=1; else
	    m_value=f;
  }

private:
  float m_value;
};

#define PARAM_VOLUME 1
#define PARAM_PITCH 2
#define PARAM_RATE 3

#endif //__VMPARAM_H__
