/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"

void intrusive_ptr_add_ref(vm_class *p)
{
  if (!p)
    VM_STOP("Trying to increase reference counter of NULL pointer.");
  p->m_refs++;
}

void intrusive_ptr_release(vm_class *p)
{
  if (!p)
    VM_STOP("Trying to release NULL pointer.");
  p->m_refs--;
  if (!p->m_refs)
    delete p;
}
