/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __PLAYER_H__
#define __PLAYER_H__

#include"confparse.h"

class vm_player : public vm_class
{
public:
  typedef vm_ptr<vm_player> ptr;
  vm_player() {};
  virtual ~vm_player() {};
  virtual void play(const vm_string &text, vm_param volume, vm_param pitch, vm_param rate, const std::vector<bool> &cap_mask) = 0;
  virtual void stop() = 0;
  virtual bool processing() const = 0;
  vm_string m_name;
};

#endif //__PLAYER_H__
