/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"
#include"langs.h"

vm_rus_lang rus_lang;
void attach_word(vm_string &str, vm_string word);

bool vm_rus_lang::init_vector(const vm_conf_parser::section &sec, std::vector<vm_string> &v, vm_string &log)
{
  vm_conf_parser::section::const_iterator i;
  v.reserve(sec.size());
  for(i=sec.begin();i!=sec.end();i++)
    {
      const vm_string &name=i->first;
      if (name[0]!=WSTR('c'))
	{
	  log += WSTR("Name of parameters should have \'c\' as first symbol in section \'")+sec.m_name+WSTR("\'.\n");
	  return 0;
	}
      vm_string num;
      int k;
      for(k=1;k<name.length();k++)
	num+=name[k];
      if (!num.is<uint>())
	{
	  log += WSTR("Name \'")+name+WSTR("\' is illegal in section \'")+sec.m_name+WSTR("\'.\n");
	  return 0;
	}
      k=num.to<uint>();
      if (v.size() < k+1)
	v.resize(k+1);
      v[k]=i->second;
    } // for
  return 1;
}

	bool vm_rus_lang::init_map(const vm_conf_parser::section &sec, std::vector<rus_char> &v, vm_string &log)
{
  vm_conf_parser::section::const_iterator i;
  for(i=sec.begin();i!=sec.end();i++)
    {
      const vm_string &value=i->second;
      if (value.length() != 3)
	{
	  log += WSTR("Values in section \'")+sec.m_name+WSTR("\' should contain 3 characters. Value \'")+ value+ WSTR("\' is invalid.\n");
	  return 0;
	}
      if (value[1]!= WSTR(':'))
	{
	  log += WSTR("Values of section \'")+ sec.m_name+ WSTR("\' should have \':\' as second character.\n");
	  return 0;
	}
      v.push_back(rus_char(value[0], value[2]));
    } // for
  return 1;
}

#define INIT_VECTOR(NAME, VECTOR) if (c.m_sections[i].m_name == WSTR(NAME)) if (!init_vector(c.m_sections[i], VECTOR, log))	 return 0;
bool vm_rus_lang::init(const vm_string &file_name, vm_string &log)
{
  vm_conf_parser c;
  if (!c.load(file_name, log))
    return 0;
  int i;
  for(i=0;i<c.m_sections.size();i++)
    if (c.m_sections[i].m_name==WSTR("general"))
      break;
  if (i >= c.m_sections.size())
    {
      log += WSTR("Thre is no section \'general\' in file with russian string constants.\n");
      return 0;
    }
  if (!c.m_sections[i].check(WSTR("chars")))
    {
      log +=WSTR("Section \'general\' should contain parameter \'chars\' in file with russian string constants.\n");
      return 0;
    }
  if (!c.m_sections[i].check(WSTR("zero")))
    {
      log +=WSTR("Section \'general\' should contain parameter \'zero\' in file with russian string constants.\n");
      return 0;
    }
  m_chars=c.m_sections[i][WSTR("chars")];
  m_zero=c.m_sections[i][WSTR("zero")];
  for(i=0;i<c.m_sections.size();i++)
    {
      INIT_VECTOR("mlrds", rus_mlrds)
	INIT_VECTOR("mlns", rus_mlns)
	INIT_VECTOR("thnds", rus_thnds)
	INIT_VECTOR("hundreds", rus_hundreds)
	INIT_VECTOR("decimals", rus_decimals)
	INIT_VECTOR("tens", rus_tens)
	INIT_VECTOR("ones", rus_ones)
	INIT_VECTOR("onesf", rus_ones_f)
	if (c.m_sections[i].m_name == WSTR("map"))
	  if (!init_map(c.m_sections[i], rus_chars, log))
	    return 0;
    } // for
  return 1;
}
#undef INIT_VECTOR

vm_string vm_rus_lang::get_chars() const
{
  return m_chars;;
}

uint vm_rus_lang::get_char_type(vm_char c) const
{
  uint i;
  for(i=0;i<rus_chars.size();i++)
    if (rus_chars[i].low_char == c)
      return 1;
  for(i=0;i<rus_chars.size();i++)
    if (rus_chars[i].up_char == c)
      return 2;
  return 0;
}

vm_string vm_rus_lang::up_case(const vm_string &str) const
{
  uint i;
  vm_string new_str;
  uint j;
  for(i=0;i<str.length();i++)
    {
      if (get_char_type(str[i]) == 1)
	{
	  for(j=0;j<rus_chars.size();j++)
	    {
	      if (rus_chars[j].low_char == str[i])
		{
		  new_str += rus_chars[j].up_char;
		  break;
		}
	    }
	} else
	  new_str += str[i];
    }
  return new_str;
}

vm_string vm_rus_lang::low_case(const vm_string &str) const
{
  uint i;
  uint j;
  vm_string new_str;
  for(i=0;i<str.length();i++)
    {
      if (get_char_type(str[i]) == 2)
	{
	  for(j=0;j<rus_chars.size();j++)
	    if (rus_chars[j].up_char == str[i])
	      {
		new_str += rus_chars[j].low_char;
		break;
	      }
	} else
	  new_str += str[i];
    }
  return new_str;
}

vm_string vm_rus_lang::process_hundred(const vm_string &in_str, const std::vector<vm_string> &items, bool female) const
{
  vm_string s, str = in_str;
  uint i;
  bool b = 0;
  if (str.length() > 3)
    VM_STOP("bad digits group");
  while(str.length() < 3)
    str = WSTR('0') + str;
  for(i=0;i<3;i++)
    if (str[i] != WSTR('0'))
      b = 1;
  if (!b)
    return WSTR("");
  if (str[0] != WSTR('0'))
    attach_word(s, rus_hundreds[str[0]-WSTR('0')]);
  if ((str[1] != WSTR('0')) && (str[1] != WSTR('1')))
    attach_word(s, rus_decimals[str[1]-WSTR('0')]);
  if (str[1] == WSTR('1'))
    {
      attach_word(s, rus_tens[str[2]-WSTR('0')]);
    } else
      {
	if (str[2] != WSTR('0'))
	  {
	    if (female)
	      attach_word(s, rus_ones_f[str[2]-WSTR('0')]); else
		attach_word(s, rus_ones[str[2]-WSTR('0')]);
	  }
      }
  if (items.empty())
		return s;
  if (str[1] == WSTR('1'))
    attach_word(s, items[2]); else
      {
	if (str[2] == WSTR('1'))
	  attach_word(s, items[0]); else
	    if ((str[2]) >= WSTR('2') && (str[2] <= WSTR('4')))
	      attach_word(s, items[1]); else
		attach_word(s, items[2]);
      }
  return s;
}

vm_string vm_rus_lang::digits_to_words(const vm_string &in_str) const
{
  uint i;
  vector<vm_string> slist;
  vm_string str;
  bool b=0;
  if (in_str.empty())
    VM_STOP("empty input");
  for(i=0;i<in_str.length();i++)
    {
      if (!((in_str[i] >= WSTR('0')) && (in_str[i] <= WSTR('9'))))
	VM_STOP("bad input digits");
      if (in_str[i] != WSTR('0'))
	b = 1;
    }
  if (!b)
    return m_zero;
  b = 0;
  for(i=0;i<in_str.length();i++)
    {
      if (in_str[i] != WSTR('0'))
	b = 1;
      if (b)
	str += in_str[i];
    }
  while(str.length())
    {
      if (str.length() >= 3)
	{
	  vm_string ss;
	  ss += str[str.length()-3];
	  ss += str[str.length()-2];
	  ss += str[str.length()-1];
	  slist.push_back(ss);
	  str.resize(str.size()-3);
	  continue;
	}
      if (str.length() == 2)
	{
	  vm_string ss;
	  ss += str[0];
	  ss += str[1];
	  slist.push_back(ss);
	  str.erase();
	  continue;
	}
      if (str.length() == 1)
	{
	  vm_string ss;
	  ss = str[0];
	  slist.push_back(ss);
	  str.erase();
	  continue;
	}
    }
  char j;
  str.erase();
  for(j=slist.size()-1;j>=0;j--)
    {
      if (j>3)
	attach_word(str, process_hundred(slist[j], std::vector<vm_string>(), 0) ); else
	  if (j == 3)
	    attach_word(str, process_hundred(slist[j], rus_mlrds, 0) ); else
	      if (j == 2)
		attach_word(str, process_hundred(slist[j], rus_mlns, 0)); else
		  if (j == 1)
		    attach_word(str, process_hundred(slist[j], rus_thnds, 1)); else
		      attach_word(str, process_hundred(slist[j], std::vector<vm_string>(), 0));
    }
  return str;
}

vm_string vm_rus_lang::insert_digits(const vm_string &in_str, bool single_digits) const
{
  if (single_digits)
    {
      uint i;
      bool b = 0;
      vm_string str;
      for(i=0;i<in_str.length();i++)
	{
	  if ((in_str[i] >= WSTR('0')) && (in_str[i] <= WSTR('9')))
	    {
	      b = 1;
	      if (in_str[i] == WSTR('0'))
		attach_word(str, m_zero); else
		  attach_word(str, rus_ones[in_str[i]-WSTR('0')]);
	    } else
	      {
		if (b)
		  {
		    str += WSTR(' ');
		    b = 0;
		  }
		str += in_str[i];
	      }
	}
      return str;
    }
  vm_string str;
  uint i;
  bool d = 0;
  vm_string sstr;
  for(i=0;i<in_str.length();i++)
    {
      if ((in_str[i]>= WSTR('0')) && (in_str[i] <= WSTR('9')))
	{
	  d = 1;
	  sstr += in_str[i];
	} else
	  {
	    if (d)
	      {
		attach_word(str, digits_to_words(sstr));
		d = 0;
		sstr.erase();
		str += WSTR(' ');
	      }
	    str += in_str[i];
	  }
    }
  if (d)
    attach_word(str, digits_to_words(sstr));
  return str;
}
