/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VMTQUEUE_H__
#define __VMTQUEUE_H__

#include"player.h"

extern volatile bool tq_idle;
extern int config_tq_limit, config_tq_delay;

void tq_add_player(vm_player::ptr player);
void tq_run();
void tq_add_text(const vm_string &name, const vm_string &text, vm_param volume, vm_param pitch, vm_param rate, const std::vector<bool> &cap_mask);
void tq_add_tone(int freq, int lengthms);
void tq_stop();

#endif // __VMTQUEUE_H__
