/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"
#include"clients.h"
#include"vmdp.h"

bool vm_dp::get_value(const vm_string &name, const vm_string &str, vm_param &p) const
{
  if (!str.is<unsigned int>())
    {
      vmlog << vmerror << WSTR("Received bad value for \'") << name << WSTR("\' parameter. Value=") << str << WSTR(".") << vmendl;
      return 0;
    }
  int k=str.to<unsigned int>();
  if (k>100)
    k=100;
  p.set_value((float)k/100);
  return 1;
}

void vm_dp::line(const vm_string &s, vm_client::ptr client)
{
  vm_char cmd;
  vm_string arg;
  if (!split(s, cmd, arg))
    {
      vmlog << vmerror << WSTR("Received bad line from client: \'") << s << WSTR("\'") << vmendl;
      return;
    }
  if (cmd == WSTR('T'))
    {
      text(client, arg);
    } else
      if (cmd == WSTR('L'))
	{
	  if (arg.length() != 1)
	    vmlog << vmerror << WSTR("Argument of LETTER command has invalid length.") << vmendl; else
	      letter(client, arg[0]);
	} else
	  if (cmd == WSTR('S'))
	    {
	      stop(client);
	    } else
	      if (cmd == WSTR('V'))
		{
		  vm_param p;
		  if (!get_value(WSTR("volume"), arg, p))
		    return;
		  param(client, PARAM_VOLUME, p);
		} else
		  if (cmd == WSTR('P'))
		    {
		      vm_param p;
		      if (!get_value(WSTR("pitch"), arg, p))
			return;
		      param(client, PARAM_PITCH, p);
		    } else
		      if (cmd == WSTR('R'))
			{
			  vm_param p;
			  if (!get_value(WSTR("rate"), arg, p))
			    return;
			  param(client, PARAM_RATE, p);
			} else
			  if (cmd == WSTR('B'))
			    {
			      vm_string p1, p2;
			      p1=arg.substr(0);
			      p2=arg.substr(1);
			      if (p1.trim().empty() || p2.trim().empty())
				{
				  vmlog << vmerror << WSTR("Missed one of the parameters for the \'TONE\' command.") << vmendl;
				  return;
				}
			      if (!p1.is<unsigned int>())
				{
				  vmlog << vmerror << WSTR("\'TONE\' command has bad parameter \'") << p1 << WSTR("\'.") << vmendl;
				  return;
				}
			      if (!p2.is<unsigned int>())
				{
				  vmlog << vmerror << WSTR("\'TONE\' has bad parameter \' ") << p2 << WSTR("\'") << vmendl;
				  return;
				}
			      tone(client, p1.to<unsigned int>(), p2.to<unsigned int>());
			    } else
			      vmlog << vmerror << WSTR("Received unknown command. (\'") << cmd << WSTR("\')") << vmendl;
}

bool vm_dp::split(const vm_string &s, vm_char &cmd, vm_string &arg)
{
  if (s.length() < 2)
    return 0;
  if (s[1] != WSTR(':'))
    return 0;
  cmd=s[0];
  arg.erase();
  int i;
  for(i=2;i<s.length();i++)
    arg+=s[i];
  return 1;
}
