/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VMDP_H__
#define __VMDP_H__

class vm_dp : public vm_class
{
public:
  typedef vm_ptr<vm_dp> ptr;
  vm_dp() {};
  virtual ~vm_dp() {};
  void line(const vm_string &s, vm_client::ptr client);
  virtual void text(vm_client::ptr client, const vm_string &t) = 0;
  virtual void letter(vm_client::ptr client, vm_char c) = 0;
  virtual void stop(vm_client::ptr client) = 0;
  virtual void param(vm_client::ptr client, int param_type, const vm_param &p) = 0;
  virtual void tone(vm_client::ptr client, int freq, int lengthms) = 0;
private:
  bool split(const vm_string &s, vm_char &cmd, vm_string &arg);
  bool get_value(const vm_string &name, const vm_string &str, vm_param &p) const;
};

#endif // __VMDP_H__
