/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include<iostream>
#include<string>
#include<vector>
#include<assert.h>
#include"cmdline.h"

void CmdArgsParser::printHelp() const
{
  std::vector<std::string> keys;
  int i;
  for(i=0;i<m_allParamCount;i++)
    {
      std::string s;
      bool hasParam = (m_allParams[i].param==NULL || m_allParams[i].param[0]=='\0');
      s = "  -";
      s += m_allParams[i].shortName;
      if (hasParam)
	{
	  s += " ";
	  s += m_allParams[i].param;
	}
      s += ", --";
      s += m_allParams[i].longName;
      if (hasParam)
	{
	  s += " ";
	  s += m_allParams[i].param;
	}
      keys.push_back(s);
    }
  int l=0;
  for(i=0;i<keys.size();i++)
    if (l < keys[i].length())
      l = keys[i].length();
  for(i=0;i<m_allParamCount;i++)
    {
      int j;
      using namespace std;
      std::string descr = m_allParams[i].descr;
      cout << keys[i];
      for(j=keys[i].length();j<l;j++)
	cout << " ";
      cout << " - " << descr << endl;
    }
}

bool CmdArgsParser::used(const std::string& name) const
{
  int i;
  for(i=0;i<m_usedParams.size();i++)
    if (m_usedParams[i].name == name)
      return 1;
  return 0;
}

const std::string CmdArgsParser::operator[](const std::string& name) const
{
  assert(used(name));
  int i;
  for(i=0;i<m_usedParams.size();i++)
    {
      if (m_usedParams[i].name != name)
	continue;
      assert(m_usedParams[i].hasValue);
      return m_usedParams[i].value;
    }
  assert(false);
}
  
int CmdArgsParser::identifyParam(char* p) const
{
  std::string s=p;
  if (s.length() < 2)
    return -1;
  if (s[0] != '-')
    return -1;
  if (s[1] != '-')
    {
      if (s.length() != 2)
	return -1;
      int i;
      for(i=0;i<m_allParamCount;i++)
	if (s[1] == m_allParams[i].shortName)
	  return i;
      return -2;
    }
  int i;
  std::string ss;
  for(i=2;i<s.length();i++)
    ss += s[i];
  for(i=0;i<m_allParamCount;i++)
    {
      std::string longName=m_allParams[i].longName;
      if (ss == longName)
	return i;
    }
  return -2;
}
  
bool CmdArgsParser::parse(int argc, char* argv[])
{
  using namespace std;
  if (argc < 1)
    {
      cerr << "ERROR: Too few arguments in argv[] array." << endl;//FIXME:
      return 0;
    }
  int i;
  for(i=1;i<argc;i++)
    {
      int p=identifyParam(argv[i]);
      if (p < -1)
	{
	  cerr << "ERROR:Unknown command line parameter \'" << argv[i] << "\'." << endl;//FIXME:
	  return 0;
	}
      if (p == -1)
	{
	  m_files.clear();
	  int z;
	  for(z=i;z<argc;z++)
	    m_files.push_back(argv[z]);
	  return 1;
	}
      USEDPARAM up;
      up.name=m_allParams[p].longName;
      if (m_allParams[p].param[0])
	{
	  if (i+1 >= argc)
	    {
	      cerr << "ERROR: Argument \'" << argv[i] << "\' requires a value but it is last item in command line. Be careful." << endl;//FIXME:
	      return 0;
	    }
	  i++;
	  up.value=argv[i];
	  up.hasValue=1;
	}
      m_usedParams.push_back(up);
    }
  return 1;
}
