/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_CMDLINE_H__
#define __VOICEMAN_CMDLINE_H__

struct CMDARG
{
  char shortName;
  char* longName;
  char* param;
  char*descr;
}; //struct CMDARG;

class CmdArgsParser
{
public:
  CmdArgsParser(CMDARG* allParams, int allParamCount):files(m_files), m_allParams(allParams), m_allParamCount(allParamCount) {}
  virtual ~CmdArgsParser() {}

  void printHelp() const;
  bool used(const std::string& name) const;
  const std::string operator [](const std::string& name) const;
  bool parse(int argc, char* argv[]);

public:
  const std::vector<std::string>& files;

private:
  struct USEDPARAM
  {
    USEDPARAM() : hasValue(0) {}

    std::string name, value;
    bool hasValue;
  }; //struct USEDPARAM;

private:
  int identifyParam(char* p) const;

private:
  std::vector<std::string> m_files;
    std::vector<USEDPARAM> m_usedParams;
    CMDARG* m_allParams;
  int m_allParamCount;
}; // class Cmdargs;

#endif //__VOICEMAN_CMDLINE_H__
