/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_TRANSCODING_H__
#define __VOICEMAN_TRANSCODING_H__

class Transcoding 
{
public:
  Transcoding();
  virtual ~Transcoding() {}

  std::string getIOCharset() const 
  {
    return m_curIO;
  }

  std::wstring trIO2WString(const std::string& s) const;
  std::string trWString2IO(const std::wstring& s) const;
  std::string trEncodeUTF8(const std::wstring& s) const;
  bool trDecodeUTF8(const std::string& s, std::wstring& res) const;
  std::wstring trReadUTF8(const std::string& s) const;

private:
  bool initIConv();
  bool initCurIO();

private:
  std::string m_curIO;
  iconv_t m_iconvIO2WString, m_iconvWString2IO, m_iconvUTF82WString, m_iconvWString2UTF8;
}; //class Transcoding;

extern Transcoding transcoding;

#define IO2WString transcoding.trIO2WString
#define WString2IO transcoding.trWString2IO
#define encodeUTF8 transcoding.trEncodeUTF8
#define decodeUTF8 transcoding.trDecodeUTF8
#define readUTF8 transcoding.trReadUTF8

std::ostream& operator <<(std::ostream& s, const std::wstring& ws);

#endif //__VOICEMAN_TRANSCODING_H__
