/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"
#include"sockets.h"
#include"clients.h"

void Client::accept(int s)
{
  assert(!m_opened);
  int r=::accept(s, NULL, NULL);
  VM_SYS(r!=-1, "accpet()");
  m_sock=r;
  m_opened=1;
}

int DispatchLoop::run(std::list<Socket*>& toListen)
{
  std::list<Client*> clients;
  while(1)
    {
      fd_set fds;
      std::list<Socket*>::iterator sockIt;
      std::list<Client*>::iterator clientIt;
      int maxFd = 0;
      FD_ZERO(&fds);
      for(sockIt=toListen.begin();sockIt!=toListen.end();sockIt++)
	{
	  int fd=(*sockIt)->getHandle();
	  if (fd > maxFd)
	    maxFd=fd;
	  FD_SET(fd, &fds);
	}
      for(clientIt=clients.begin();clientIt!=clients.end();clientIt++)
	{
	  int fd=(*clientIt)->getHandle();
	  if (fd > maxFd)
	    maxFd=fd;
	  FD_SET(fd, &fds);
	}
      VM_SYS(select(maxFd+1, &fds, NULL, NULL, NULL) != -1, "select()");
      bool wasNewClients=0;
      for(sockIt=toListen.begin();sockIt!=toListen.end();sockIt++)
	{
	  int fd=(*sockIt)->getHandle();
	  if (!FD_ISSET(fd, &fds))
	    continue;
	  wasNewClients=1;
	  auto_ptr<Client> c(new Client(m_defaultVolume, m_defaultPitch, m_defaultRate));
	  try {
	    c->accept(fd);
	    if (m_maxClients == 0 || clients.size() < m_maxClients)
	      clients.push_back(c.release()); else
		logMsg(LOG_WARN, "Too many clients. Rejecting new connection.");
	  }
	  catch(const Exception& e)
	    {
	      e.makeLogReport();
	      logMsg(LOG_ERROR, "There was a new client but connection could not be accepted.");
	    }
	  logMsg(LOG_INFO, "New client accepted.");
	}
      if (wasNewClients)
	continue;
      for(clientIt=clients.begin();clientIt!=clients.end();clientIt++)
	{
	  int fd=(*clientIt)->getHandle();
	  if (!FD_ISSET(fd, &fds))
	    continue;
	  std::string data;
	  bool toClose=0;
	  try {
	    toClose=!(*clientIt)->read(data);
	    if (toClose)
	      logMsg(LOG_INFO, "Closing connection.");
	  }
	  catch(const Exception& e)
	    {
	      e.makeLogReport();
	      logMsg(LOG_ERROR, "Could not read data from the client. Closing this connection.");
	      toClose=1;
	    }
	  if (toClose)
	    {
	      (*clientIt)->close();
	      delete *clientIt;
	      clients.erase(clientIt);
	      break;
	    } // closing connection;
	  handleData(readUTF8(data), **clientIt);
	} // for clients;
    } // Endless loop for connections handling;
  return 0;
}
