/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_CLIENTS_H__
#define __VOICEMAN_CLIENTS_H__

class Client: public Socket
{
public:
 Client(): m_rejecting(0) {}
  Client(TextParam defaultVolume, TextParam defaultPitch, TextParam defaultRate): m_rejecting(0), m_volume(defaultVolume), m_pitch(defaultPitch), m_rate(defaultRate) {}
  virtual ~Client() {}

  void accept(int fd);

  std::wstring getChain() const
  {
    return m_chain;
  }

  void setChain(const std::wstring& chain)
  {
    m_chain=chain;
  }

  TextParam getVolume() const
  {
    return m_volume;
  }

  void setVolume(TextParam value)
  {
    m_volume = value;
  }

  TextParam getPitch() const
  {
    return m_pitch;
  }

  void setPitch(TextParam value)
  {
    m_pitch=value;
  }

  TextParam getRate() const
  {
    return m_rate;
  }

  void setRate(TextParam value)
  {
    m_rate=value;
  }

  bool isRejecting() const
  {
    return m_rejecting;
  }

  void setRejectingState(bool value)
  {
    m_rejecting=value;
  }

private:
  std::wstring m_chain;
  TextParam m_volume, m_pitch, m_rate;
  bool m_rejecting;
}; //class Client;

class DispatchLoop
{
public:
  DispatchLoop(int maxClients, TextParam defaultVolume, TextParam defaultPitch, TextParam defaultRate): m_maxClients(maxClients), m_defaultVolume(defaultVolume), m_defaultPitch(defaultPitch), m_defaultRate(defaultRate) {}
  virtual ~DispatchLoop() {}

  virtual void handleData(const std::wstring& data, Client& client) = 0;
  int run(std::list<Socket*>& toListen);

private:
  int m_maxClients;
  TextParam m_defaultVolume, m_defaultPitch, m_defaultRate;
}; //class DispatchLoop;

#endif // __VOICEMAN_CLIENTS_H__
