/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_COMMAND_H__
#define __VOICEMAN_COMMAND_H__

class CommandPlayer: public Player
{
public:
  CommandPlayer(): m_pg(0) {}
 CommandPlayer(const std::string& name): Player(name), m_pg(0) {}
  virtual ~CommandPlayer() {}

  void play(const TextItem& textItem);
  void stop();
  bool processing() const;
  void init(const OutputConfiguration& outputConfiguration);

private:
  std::string prepareFloatValue(TextParam value, const FloatValueParams& format) const;
  std::string prepareCommandLine(TextParam volume, TextParam pitch, TextParam rate) const;
  std::string prepareText(const TextItem& textItem) const;
  std::wstring makeCaps(const TextItem& textItem) const;

private:
  std::map<wchar_t, std::wstring> m_capList;
  std::string m_cmdLine;
  FloatValueParams m_volumeFormat, m_pitchFormat, m_rateFormat;
  int m_pg;
}; //class CommandPlayer;

#endif // __VOICEMAN_PLAYER_H__
