/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_CONFIGURATION_H__
#define __VOICEMAN_CONFIGURATION_H__

struct DISPATCHERPARAMS
{
  DISPATCHERPARAMS():
    maxLine(0),
    maxClients(0),
    digitsMode(DIGITS_NORMAL),
    tones(1),
    tonesInQueue(1),
    capitalization(1),
    separation(1) {}

  TextParam defaultVolume, defaultPitch, defaultRate;
  int maxClients, maxLine, digitsMode;
  bool tones, tonesInQueue, capitalization, separation;
}; //struct DISPATCHERPARAMS;


class FloatValueParams
{
public:
  FloatValueParams(): digits(2), min(0), max(1) {}

  void init(const std::string& value, const std::string& outputName, const std::string& name);

public:
  int digits;
  float min, max;
}; //struct FLOATVALUEPARAM;

class OutputConfiguration
{
public:
  enum{COMMAND = 0};

  OutputConfiguration() {}

  void init(const ConfigFileSection& section);
  void printConfiguration() const;

public:
  int type;
  std::string name, lang, command;
  FloatValueParams volumeParams, pitchParams, rateParams;
  std::map<wchar_t, std::wstring> capReplacements;
}; //class OutputConfiguration;

class Configuration
{
public:
 Configuration():
    digitsMode(DIGITS_NORMAL),
    tones(0),
    tonesInQueue(1),
      startUpMessage(L"VoiceMan is ready"),
    capitalization(1),
    separation(1),
    maxClients(10),
    maxQueue(1000),
    loopDelay(50000),
    maxLine(8192),
    dataDir(VOICEMAN_DEFAULT_DATADIR),
    unixSocket(""),
    useInetSocket(0),
    logLevel(LOG_WARN),
    logToStdErr(1)
  {}

  virtual ~Configuration() {}

public:
  std::wstring startUpMessage;

  std::string defaultOutputName;
    std::wstring defaultOutputChars;

  std::string logFileName;
  int logLevel;
  bool logToStdErr;

  std::string pidFileName;
  std::string dataDir;
  std::wstring toSay;
  bool daemon;
  bool testConfiguration;
  int maxQueue;
  int loopDelay;

  std::string unixSocket;
  bool useInetSocket;
  int inetPort;

  TextParam defaultVolume;
  TextParam defaultPitch;
  TextParam defaultRate;
  int maxClients;
  int maxLine;
  int digitsMode;
  bool tones;
  int tonesInQueue;
  bool capitalization;
  bool separation;

  std::vector<OutputConfiguration> outputs;

public:
  void printConfiguration() const;

    DISPATCHERPARAMS prepareDispatcherParams() const
  {
    DISPATCHERPARAMS p;
    p.defaultVolume=defaultVolume;
    p.defaultPitch=defaultPitch;
    p.defaultRate=defaultRate;
    p.maxClients=maxClients;
    p.maxLine=maxLine;
    p.digitsMode=digitsMode;
    p.tones=tones;
    p.tonesInQueue=tonesInQueue;
    p.capitalization=capitalization;
    p.separation=separation;
    return p;
  }
}; //class Configuration;

class VoicemanConfigFile: public ConfigFile
{
public:
  VoicemanConfigFile() {}
  virtual ~VoicemanConfigFile() {}

  int params(const std::string& section, const std::string& param) const;
}; //class VoicemanConfigFile;

#endif //__VOICEMAN_CONFIGURATION_H__
