/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_DISPATCHER_H__
#define __VOICEMAN_DISPATCHER_H__


class Dispatcher: public DispatchLoop, public VoicemanProtocol
{
public:
  Dispatcher(const DISPATCHERPARAMS& p): DispatchLoop(p.maxClients, p.defaultVolume, p.defaultPitch, p.defaultRate),
					 m_proc(createNewTextProcessor(p.digitsMode, p.capitalization, p.separation)),
					 m_params(p) {}
  virtual ~Dispatcher() {}

  void initTextProcessor(const Configuration& configuration);
  void handleData(const std::wstring& data, Client& client);
  void text(const Client& client, const std::wstring& t);
  void letter(const Client& client, wchar_t c);
  void stop(const Client& client);
  void param(Client& client, int paramType, TextParam value);
  void tone(const Client& client, int freq, int lengthMs);

private:
  std::wstring splitAndProcess(const std::wstring& data, Client& client);

private:
  DISPATCHERPARAMS m_params;
  auto_ptr<TextProcessor> m_proc;
}; // class Dispatcher;

#endif //__VOICEMAN_DISPATCHER_H__
