/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_ENG_H__
#define __VOICEMAN_ENG_H__

class EngLang: public Lang
{
public:
  EngLang() {}
  virtual ~EngLang() {}

  void load(const std::string& fileName);
  int getCharType(wchar_t c) const;
  std::wstring getAllChars() const;
  bool equalChars(wchar_t c1, wchar_t c2) const;
  wchar_t toUpper(wchar_t ch) const;
  wchar_t toLower(wchar_t ch) const;
  std::wstring toUpper(const std::wstring& str) const;
  std::wstring toLower(const std::wstring& str) const;
  void expandNumbers(std::wstring& str, bool singleDigits) const;
  std::wstring separate(const std::wstring& text) const;
  void markCapitals(const std::wstring& text, std::vector<bool>& marks) const;

private:
  struct CAPITEM
  {
    CAPITEM(): before(0), after(0) {}
    CAPITEM(const std::wstring& s, bool b, bool a): str(s), before(b), after(a) {}

    std::wstring str;
    bool before, after;
  }; //struct CAPITEM;

private:
  std::wstring processHundred(const std::wstring& inStr, const wchar_t* const items[]) const;
  std::wstring digitsToWords(const std::wstring& inStr) const;
  bool checkCapList(const std::wstring& str, int pos, std::wstring& result) const;
  void processCapList(const std::wstring& str, std::vector<bool>& marks) const;

private:
  std::list<CAPITEM> m_capItems;
};//class EngLang;

#endif //__VOICEMAN_ENG_H__
