/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"

static std::string cutComments(const std::string& str)
{
  std::string s;
  for(int i=0;i<str.length();i++)
    {
      if (str[i]=='#')
	return s;
      s+=str[i];
    }
  return s;
}

std::string readTextFile(const std::string& fileName)
{
  int fd=open(fileName.c_str(), O_RDONLY);
  VM_SYS(fd!= -1, fileName);
  std::string s;
  char buf[2048];
  int readCount;
  do {
    readCount=read(fd, buf, sizeof(buf));
    VM_SYS(readCount>=0, "read()");
    for(int i=0;i<readCount;i++)
      s+=buf[i];
  } while(readCount);
  close(fd);
  return s;
}

void DelimitedFile::read(const std::string& fileName)
{
  logMsg(LOG_TRACE, "Reading delimited file \'%s\'", fileName.c_str());
  std::string s;
  m_lines.clear();
  s=readTextFile(fileName);
  std::string ss;
  s+=10;
  int i;
  for(i=0;i<s.length();i++)
    {
      if (s[i]==13)
	continue;
      if (s[i]==10)
	{
	  ss=cutComments(trim(ss));
	  if (!ss.empty())
	    m_lines.push_back(ss);
	  ss.erase();
	  continue;
	} // if 10;
      ss+=s[i];
    } // for;
}

int DelimitedFile::getItemCountInLine(int line) const
{
  assert(line < m_lines.size());
  const std::string& s=m_lines[line];
  int k=0;
  for(int i=0;i<s.length();i++)
    if (s[i]==':')
      k++;
  return k;
}

std::string DelimitedFile::getItem(int line, int itemIndex) const
{
  assert(line<m_lines.size());
  return getDelimitedSubStr(m_lines[line], itemIndex, ':');
}
