/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_FILES_H__
#define __VOICEMAN_FILES_H__

std::string readTextFile(const std::string& fileName);

class DelimitedFile
{
public:
  DelimitedFile() {}
  virtual ~DelimitedFile() {}

  void read(const std::string& fileName);

  int getLineCount() const
  {
    return m_lines.size();
  }

  std::string getRawLine(int index) const
  {
    assert(index <= m_lines.size());
    return m_lines[index];
  }

  int getItemCountInLine(int line) const;
  std::string getItem(int line, int itemIndex) const;

private:
  std::vector<std::string> m_lines;
}; //class DelimitedFile;

#endif //__VOICEMAN_FILES_H__
