/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"
#include"config.h"
#include"configuration.h"
#include"languages.h"
#include"eng.h"
#include"rus.h"

Languages languages;
static EngLang engLang;
static RusLang rusLang;

bool Languages::checkLanguage(const std::string& name) const
{
  if (trim(toLower(name))=="eng")
    return 1;
  if (trim(toLower(name))=="rus")
    return 1;
  return 0;
}

const Lang* Languages::getLang(const std::string& name) const
{
  if (trim(toLower(name))=="eng")
    return &engLang;
  if (trim(toLower(name))=="rus")
    return &rusLang;
  logMsg(LOG_TRACE, "Requested unknown language \'%s\'", name.c_str());
  return NULL;
}

void Languages::load(const std::string& dataDir)
{
  logMsg(LOG_TRACE, "Loading caps...");
  engLang.load(dataDir+"caps");
  logMsg(LOG_TRACE, "Loading Russian constants...");
  rusLang.load(dataDir+"ru_const");
}
