/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"system.h"
#include"logging.h"

#define VOICEMAN_ERROR_EXIT_CODE 2

std::string configLogFileName;
bool configLogConsole=1;
int configLogLevel=LOG_WARN;

static std::string getCurrentTime()
{
  std::string s;
  time_t t;
  time(&t);
  s=ctime(&t);
  int i;
  std::string ss;
  for(i=0;i<s.length();i++)
    if (s[i]!=10 && s[i]!=13)
      ss+=s[i];
  return ss;
}

static void printLogLine(int level, const char* line)
{
  if (!configLogConsole)
    return;
  if (level<=LOG_FATAL)
    {
      std::cerr << "FATAL:" << line << std::endl;
      return;
    }
  if (level <= LOG_ERROR)
    {
      std::cerr << "ERROR:" << line << std::endl;
      return;
    }
  if (level <= LOG_WARN)
    {
      std::cerr << "WARN:" << line << std::endl;
      return;
    }
  std::cout << line << std::endl;
}

static void saveLogLine(int level, const char* line)
{
  if (configLogFileName.empty())
    return;
  std::ofstream f(configLogFileName.c_str(), std::ios_base::out | std::ios_base::app);
  if (!f)
    return;
  f << getCurrentTime() << ':';
  if (level<= LOG_FATAL)
    f << "FATAL:";  else
      if (level <= LOG_ERROR)
	f << "ERROR:"; else
	  if (level <= LOG_WARN)
	    f << "WARNING:"; else
	      if (level <= LOG_INFO)
		f << "INFO:"; else
		  f << "TRACE:";
  f << line << std::endl;
}

static void logLine(int level, const char* line)
{
#ifndef VOICEMAN_DEBUG
  if (level > configLogLevel)
    return;
#endif
  printLogLine(level, line);
  saveLogLine(level, line);
}

void logMsg(int level, const char* format, ...)
{
  if (!format)
    return;
  va_list args;
  va_start(args, format);
  char buf[4096];
  vsnprintf(buf, sizeof(buf), format, args);
  buf[sizeof(buf)-1]='\0';
  va_end(args);
  logLine(level, buf);
}

void sysStop(const std::string& msg)
{
  logMsg(LOG_FATAL, "SYSTEM CALL FAIL:%s:%s", msg.c_str(), strerror(errno));
  exit(VOICEMAN_ERROR_EXIT_CODE);
}

