/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_PLAYER_H__
#define __VOICEMAN_PLAYER_H__

class Player
{
public:
  Player() {}
  Player(const std::string& name): m_name(name) {}
  virtual ~Player() {}

  virtual void play(const TextItem& textItem) = 0;
  virtual void stop() = 0;
  virtual bool processing() const = 0;

  std::string getName() const
  {
    return m_name;
  }

  void setName(const std::string& name)
  {
    m_name=name;
  }

protected:
  std::string m_name;
};

#endif //__VOICEMAN_PLAYER_H__
