/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_PROTOCOL_H__
#define __VOICEMAN_PROTOCOL_H__

class VoicemanProtocol
{
public:
  VoicemanProtocol() {}
  virtual ~VoicemanProtocol() {}

  void line(const std::wstring& s, Client& client);

  virtual void text(const Client& client, const std::wstring& t) = 0;
  virtual void letter(const Client& client, wchar_t c) = 0;
  virtual void stop(const Client& client) = 0;
  virtual void param(Client& client, int paramType, TextParam value) = 0;
  virtual void tone(const Client& client, int freq, int lengthMs) = 0;

private:
  bool split(const std::wstring& s, wchar_t& cmd, std::wstring& arg);

  void prLetter(const std::wstring& value, const Client& client);
  void prParam(int paramType, const std::wstring& value, Client& client);
  void prTone(const std::wstring& value, const Client& client);
}; //class VoicemanProtocol;

#endif //__VOICEMAN_PROTOCOL_H__
