/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_RUS_H__
#define __VOICEMAN_RUS_H__

class RusLang: public Lang
{
public:
  RusLang() {}
  virtual ~RusLang() {}

  void load(const std::string& fileName);
  int getCharType(wchar_t c) const;
  std::wstring getAllChars() const;
  bool equalChars(wchar_t c1, wchar_t c2) const;
  wchar_t toUpper(wchar_t ch) const;
  wchar_t toLower(wchar_t ch) const;
  std::wstring toUpper(const std::wstring& str) const;
  std::wstring toLower(const std::wstring& str) const;
  void expandNumbers(std::wstring& str, bool singleDigits) const;
  std::wstring separate(const std::wstring& text) const;
  void markCapitals(const std::wstring& text, std::vector<bool>& marks) const;

private:
  std::wstring processHundred(const std::wstring& inStr, const std::vector<std::wstring>& items, bool female) const;
  std::wstring digitsToWords(const std::wstring& inStr) const;

private:
  std::wstring m_chars, m_zero;
  std::vector<std::wstring> m_mlrds, m_mlns, m_thnds, m_hundreds, m_decimals, m_tens, m_ones, m_onesF;
  std::map<wchar_t, wchar_t> m_toUpper, m_toLower;
};//class RusLang;

#endif //__VOICEMAN_RUS_H__
