/*
	Copyright (c) 2000-2007 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_SOCKETS_H__
#define __VOICEMAN_SOCKETS_H__

typedef long IPADDR;

class Socket
{
public:
  Socket() : m_sock(0), m_opened(0) {}
  virtual ~Socket() {close();}

  int read(void *buf, int s) const;
  int write(const void *buf, int s) const;
  bool read(std::string &s) const;
  void write(const std::string &s) const;
  virtual void close();

  int getHandle() const
  {
    assert(m_opened);
    return m_sock;
  }

  bool opened() const 
  {
    return m_opened;
  };

protected:
  int m_sock;
  bool m_opened;
}; //class Socket;

class UnixSocket: public Socket
{
public:
  UnixSocket() {}
  virtual ~UnixSocket() {}

  void open(const std::string& name);
}; //class UnixSocket;

class InetSocket: public Socket
{
public:
  InetSocket() {}
  virtual ~InetSocket() {}

  void open(int port);
}; //class InetSocket;

#endif // __VOICEMAN_SOCKETS_H__
