
#ifndef __VOICEMAN_CONFIG_FILE_H__
#define __VOICEMAN_CONFIG_FILE_H__

//FIXME:Dublicating keys checking;
//FIXME:underline in keys;

#include"ConfigFileException.h"
#include"ConfigFileValueTypeException.h"
#include"ConfigFileSection.h"

#define VOICEMAN_BEGIN_PARAM_TABLE(cl) int cl::params(const std::string& section, const std::string& param) const {
#define VOICEMAN_RELAX_SECTION(s) if (section==(s)) return ANY_VALUE
#define VOICEMAN_DECLARE_PARAM(s,p) if (section==(s) && param==(p)) return ANY_VALUE
#define VOICEMAN_DECLARE_BOOLEAN_PARAM(s,p) if (section==(s) && param==(p)) return BOOLEAN_VALUE
#define VOICEMAN_DECLARE_STRING_PARAM(s,p) if (section==(s) && param==(p)) return STRING_VALUE
#define VOICEMAN_DECLARE_INT_PARAM(s,p) if (section==(s) && param==(p)) return INT_VALUE
#define VOICEMAN_DECLARE_UINT_PARAM(s,p) if (section==(s) && param==(p)) return UINT_VALUE
#define VOICEMAN_DECLARE_DOUBLE_PARAM(s,p) if (section==(s) && param==(p)) return DOUBLE_VALUE
#define VOICEMAN_END_PARAM_TABLE return INVALID_VALUE;}

/**\brief The configuration file parser
 *
 * This is the main class to parse configuration file. It reads all data
 * from file, constructs the set of ConfigFileSection objects and fills
 * them with read data. User can analyze prepared information and perform
 * required handling. This class can also check data types by the data
 * types table, defined in child class. None of the data semantics is
 * processed by this class.
 */
class ConfigFile
{
public:
  /**\brief The default constructor*/
  ConfigFile() {}

  /**\brief The destructor*/
  virtual ~ConfigFile() {}

  /**\brief Loads configuration file content
   *

   * This method saves processed data in the internal structures inside 
   * of this class. Any data can be retrieved later.
   * On any error this method throws ConfigFileException.
   * This method does not perform any value type checking. You should explicitly call checkParams() method to do it.
   * This  method saves processed data in the internal structures inside 
   * of the class. Any required information can be retrieved later through corresponding methods. On any error this method throws ConfigFileException.
   * None of the data types checking is performed by this method. You should explicitly call checkParams() method to do it.
   *
   * \param [in] fileName The name of a file to read data from
   */
  void load(const std::string& fileName);

  /**\brief Checks read values type matching
   *
   * This method looks through read values and checks its types. If error 
   * is found the ConfigFileValueTypeException will be thrown. Checking is performed 
   * by the data provided by params() method. You should override this method in your child classe.
   * There are predefined macroses to define data types table.
   */
  void checkParams() const;

  /**\brief Returns the number of read sections*/
  ConfigFileSectionVector::size_type getSectionCount() const;

  /**\brief Returns the reference to the section object by the section index
   *
   * \param [in] index The index of a section to return
   */
  const ConfigFileSection& getSection(ConfigFileSectionVector::size_type index) const;

  /**\brief Returns the reference to the section object by the section name
   *
   * \param [in] name The name of a section to return
   */
  const ConfigFileSection& findSection(const std::string& name) const;

  /**\brief Checks if the specified section is accessible
   *
   * \param [in] name The name of a section to check
   */
  bool hasSection(const std::string& name) const;

protected:
  enum {ANY_VALUE = -1, INVALID_VALUE = 0, BOOLEAN_VALUE = 1, STRING_VALUE = 2, INT_VALUE = 3, UINT_VALUE = 4, DOUBLE_VALUE = 5};
  virtual int params(const std::string& section, const std::string& param) const = 0;

private:
  int process(const std::string& line, int& code, std::string& str1, std::string& str2) const;
  void checkParamsInSection(const ConfigFileSection& section) const;

private:
  ConfigFileSectionVector m_sections;
}; //class ConfigFile;

#endif // __VOICEMAN_CONFIG_FILE_H__
