
#ifndef __VOICEMAN_CONFIG_FILE_VALUE_TYPE_EXCEPTION_H__
#define __VOICEMAN_CONFIG_FILE_VALUE_TYPE_EXCEPTION_H__

#include"system/logging.h"
#include"VoicemanException.h"

/**\brief The exception class to notify about parameter value type mismatch*/
class ConfigFileValueTypeException: public VoicemanException
{
public:
  /**\brief The constructor
   *
   * \param [in] descr The error description
   */
  ConfigFileValueTypeException(const std::string& descr)
    : m_descr(descr) {}

  /**\brief The destructor*/
  virtual ~ConfigFileValueTypeException() {}

  /**\brief Returns the error description*/
  std::string getMessage() const
  {
    return m_descr;
  }

  /**\brief Sends error description to logging system*/
  void makeLogReport(int level) const
  {
    logMsg(level, "config file value type mismatch:%s", getMessage().c_str());
  }

private:
  const std::string m_descr;
}; //class ConfigFileValueTypeException;

#endif //__VOICEMAN_CONFIG_FILE_VALUE_TYPE_EXCEPTION_H__
