
#ifndef __VOICEMAN_CLIENT_H__
#define __VOICEMAN_CLIENT_H__

#include"TextParam.h"
#include"system/sockets.h"

/**\brief The class to store client specific data
 *
 * This class stores all information about client connection. It contains
 * current values for all text attributes, assigned for this connection
 * and a socket object for data exchange. One client can has only one
 * instance of this object because it automatically closes socket on
 *object destruction.
 */
class Client
{
public:
  /**\brief The default constructor*/
  Client()
    : rejecting(0) {}

  /**\brief The constructor with socket object specification
   *
   * \param [in] s The socket object for data exchange
   */
  Client(auto_ptr<Socket> s)
    : rejecting(0), socket(s) {}

  /**\brief The destructor*/
  virtual ~Client() {}

public:
  std::wstring chain;
  TextParam volume, pitch, rate;
  LangIdToStringMap m_selectedFamilies;
  std::string m_selectedTextProcessor;

  bool rejecting;
  auto_ptr<Socket> socket;
}; //class Client;

typedef std::list<Client*> ClientList;

#endif // __VOICEMAN_CLIENT_H__
