
#ifndef __VOICEMAN_CLIENT_FACTORY_H__
#define __VOICEMAN_CLIENT_FACTORY_H__

#include"Client.h"

/**\brief The new client object factory
 *
 * This class performs new client object creation. It contains initial
 * values for text processing parameters and sets them to all newly
 * created objects. The reference to this factory must be provided to
 * main loop class to proper creation of new client objects.
 */
class ClientFactory
{
public:
  /**\brief Creates new client object and sets initial values to all parameters
   *
   * \param [in] socket The socket object new client must be associated with
   */
  auto_ptr<Client> createNewClient(auto_ptr<Socket> socket) const
  {
    auto_ptr<Client> client(new Client(socket));
    client->volume = defaultVolume;
    client->pitch = defaultPitch;
    client->rate = defaultRate;
    client->m_selectedTextProcessor = "all";
    return client;
  }

  auto_ptr<Client> createFakeClient() const
  {
    auto_ptr<Client> client(new Client());
    client->volume = defaultVolume;
    client->pitch = defaultPitch;
    client->rate = defaultRate;
    client->m_selectedTextProcessor = "all";
    return client;
  }

public:
  TextParam defaultVolume, defaultPitch, defaultRate;
}; //class ClientFactory;

#endif //__VOICEMAN_CLIENT_FACTORY_H__
