
#ifndef __VOICEMAN_ENG_LANG_H__
#define __VOICEMAN_ENG_LANG_H__
//FIXME:good comments;
#include"core/Lang.h"

class EngLang: public Lang
{
public:
  virtual ~EngLang() {}

  void loadCaps(const std::string& fileName);//FIXME:

  Lang::CharType getCharType(wchar_t c) const;
  std::wstring getAllChars() const;
  bool equalChars(wchar_t c1, wchar_t c2) const;
  wchar_t toUpper(wchar_t ch) const;
  wchar_t toLower(wchar_t ch) const;
  std::wstring toUpper(const std::wstring& str) const;
  std::wstring toLower(const std::wstring& str) const;
  void expandNumbers(std::wstring& str, bool singleDigits) const;
  std::wstring separate(const std::wstring& text) const;
  void markCapitals(const std::wstring& text, BoolVector& marks) const;

private:
  struct CapItem
  {
    CapItem(): before(0), after(0) {}
    CapItem(const std::wstring& s, bool b, bool a)
      : str(s), before(b), after(a) {}

    std::wstring str;
    bool before, after;
  }; //struct CapItem;

  typedef std::vector<CapItem> CapItemVector;
  typedef std::list<CapItem> CapItemList;

private:
  std::wstring processHundred(const std::wstring& inStr, const wchar_t* const items[]) const;
  std::wstring digitsToWords(const std::wstring& inStr) const;
  bool checkCapList(const std::wstring& str, std::wstring::size_type pos, std::wstring& result) const;
  void processCapList(const std::wstring& str, BoolVector& marks) const;

private:
  CapItemList m_capItems;
};//class EngLang;

#endif //__VOICEMAN_ENG_H__
