
#include"voiceman.h"
#include"LangManager.h"
#include"EngLang.h"
#include"RusLang.h"

LangManager langManager;

enum {LangIdEng = 1, LangIdRus = 2};

static EngLang engLang;
static RusLang rusLang;

void LangManager::getSupportedLanguageNames(StringList& stringList) const
{
  stringList.clear();
  stringList.push_back("eng");
  stringList.push_back("rus");
}

bool LangManager::hasLanguage(const std::string& name) const
{
  if (trim(toLower(name)) == "eng")
    return 1;
  if (trim(toLower(name)) == "rus")
    return 1;
  return 0;
}

LangId LangManager::getLangId(const std::string& name) const 
{
  if (trim(toLower(name)) == "eng")
    return LangIdEng;
  if (trim(toLower(name)) == "rus")
    return LangIdRus;
  return LANG_ID_NONE;
}

std::string LangManager::getLangName(LangId langId) const
{
  if (langId == LangIdEng)
    return "eng";
  if (langId == LangIdRus)
    return "rus";
  return "";
}

const Lang* LangManager::getLangById(LangId langId) const
{
  if (langId == LangIdEng)
    return &engLang;
  if (langId == LangIdRus)
    return &rusLang;
  return NULL;
}

void LangManager::load(const std::string& dataDir)
{
  engLang.loadCaps(concatUnixPath<std::string>(dataDir, "caps"));
  rusLang.load(concatUnixPath<std::string>(dataDir, "ru_const"));
}
