
#ifndef __VOICEMAN_RUS_LANG_H__
#define __VOICEMAN_RUS_LANG_H__

#include"core/Lang.h"

class RusLang: public Lang
{
public:
  RusLang() {}
  virtual ~RusLang() {}

  void load(const std::string& fileName);
  Lang::CharType getCharType(wchar_t c) const;
  std::wstring getAllChars() const;
  bool equalChars(wchar_t c1, wchar_t c2) const;
  wchar_t toUpper(wchar_t ch) const;
  wchar_t toLower(wchar_t ch) const;
  std::wstring toUpper(const std::wstring& str) const;
  std::wstring toLower(const std::wstring& str) const;
  void expandNumbers(std::wstring& str, bool singleDigits) const;
  std::wstring separate(const std::wstring& text) const;
  void markCapitals(const std::wstring& text, BoolVector& marks) const;

private:
  std::wstring processHundred(const std::wstring& inStr, const WStringVector& items, bool female) const;
  std::wstring digitsToWords(const std::wstring& inStr) const;

private:
  typedef std::map<wchar_t, wchar_t> WCharToWCharMap;

  std::wstring m_chars, m_zero;
  WStringVector m_mlrds, m_mlns, m_thnds, m_hundreds, m_decimals, m_tens, m_ones, m_onesF;
  WCharToWCharMap m_toUpper, m_toLower;
};//class RusLang;

#endif //__VOICEMAN_RUS_LANG_H__
