
#include"vmemacspeak_base.h"
#include"Connection.h"

/**\brief The current connection to voicemand*/
static vm_connection_t con = VOICEMAN_BAD_CONNECTION;

/**\brief Sends the text to voicemand to speak
 *
 * This function checks the connection to voicemand.
 * If a connection was not established, it tries to connect. If new attempt 
 * fails, this function do nothing silently or transmits the text data otherwise.
 *
 * \param [in] t The text to send
 */
void text(const std::string& t)
{
  std::string s=encodeUTF8(IO2WString(t));
  if (con==VOICEMAN_BAD_CONNECTION)
    con=vm_connect();
  if (con != VOICEMAN_BAD_CONNECTION)
    vm_text(con, s.c_str());
}

/**\brief Sends a letter command to daemon
 *
 * This function checks the connection to voicemand.
 * If a connection was not established, it tries to connect. If new attempt 
 * fails, this function do nothing silently or transmits the text data otherwise.
 *( \param l The letter bytes
 */
void letter(const std::string& l)
{
  std::wstring t=IO2WString(l);
  if (t.length()>1)
    t.resize(1);
  std::string s=encodeUTF8(t);
  if (con == VOICEMAN_BAD_CONNECTION)
    con=vm_connect();
  if (con != VOICEMAN_BAD_CONNECTION)
    vm_letter(con, s.c_str());
}

/**\brief Stops any speech playback on speech server
 *
 * This function checks the connection like text() or letter() functions
 */
void stop()
{
  if (con == VOICEMAN_BAD_CONNECTION)
    con = vm_connect();
  if (con != VOICEMAN_BAD_CONNECTION)
    vm_stop(con);
}


/**\brief Sens a tone command to voiceman daemon
 *
 * This function checks connection like text() or letter() functions.
 *
 * \param freq The desired frequency of a command to send
 * \param [in] lenthMs The desired length of a command to send
 */
void tone(int freq, int lengthMs)
{
  if (con == VOICEMAN_BAD_CONNECTION)
    con=vm_connect();
  if (con != VOICEMAN_BAD_CONNECTION)
    vm_tone(con, freq, lengthMs);
}
