


/**\brief Parses one line of emacspeak protocol
 *
 * \param [in] str The string to parse
 * \param [in] line The object to save extracted information
 */
void splitEspeakLine(const std::string& str, ESPEAKLINE& line)
{
  int &level = line.brLevel;
  std::string next;
  bool toParams;
  if (level)
    {
      if (line.params.size())
	{
	  next = line.params[line.params.size()-1];
	  line.params.pop_back();
	  toParams = 1;
	} else
	{
	  next = line.cmd;
	  line.params.clear();
	  line.cmd.erase();
	  toParams = 0;
	}
    } else
    {
      line.cmd.erase();
      line.params.clear();
      toParams = 0;
    }
  unsigned int i;
  int state;
  if (level)
    state = 4; else
    state = 2;
  for(i=0;i<str.length();i++)
    {
      if (str[i] == ' ')
	{
	  if (state == 2)
	    continue;
	  if (state == 1)
	    {
	      state = 2;
	      continue;
	    }
	  if (state == 4)
	    {
	      next+=' ';
	      continue;
	    }
	  if (state == 0 || state == 5)
	    {
	      if (toParams)
		line.params.push_back(next); else
		  line.cmd = next;
	      next.erase();
	      toParams=1;
	      state = 1;
	      continue;
	    }
	  assert(0);
	} // spaces;
      if (str[i]=='{')
	{
	  if (state==1 || state == 2)
	    {
	      next.erase();
	      state = 4;
	      level=1;
	      continue;
	    }
	  if (state == 4)
	    {
	      next+=str[i];
	      level++;
	      continue;
	    }
	  if (state == 0)
	    {
	      next+=str[i]; 
	      continue;
	    }
	  continue;
	} // opening bracket;
      if (str[i] == '}')
	{
	  if (state == 4)
	    {
	      if (level==1)
		{
		  state=5;
		  level=0;
		} else
		  if (level > 1)
		    {
		      next+=str[i]; 
		      level--;
		    } else
		      {
			assert(0);
		      }
	      continue;
	    }
	  if (state == 0)
	    {
	      next+=str[i];
	      continue;
	    }
	  continue;
	} // closing bracket;
      // any char;
      if (state==0 || state==4)
	{
	  next+=str[i]; 
	  continue;
	}
      if (state == 1 || state == 2)
	{
	  next = str[i]; 
	  state = 0;
	}
    } // for
  if (state == 0 || state == 4 || state== 5)
    {
      if (toParams)
	line.params.push_back(next); else
	  line.cmd = next;
    }
}
