//FIXME:good comments;
#ifndef __VOICEMAN_STRINGS_H__
#define __VOICEMAN_STRINGS_H__

#define BLANK_CHAR(x) ((x)==10 || (x)==13 || (x)==9 || (x)==32)
#define DIGIT_CHAR(x) ((x)>='0' && (x)<='9')

template<class TStr>
TStr concatUnixPath(const TStr& part1, const TStr& part2)
{
  if (part1.empty() && part2.empty())
    return TStr();
  if (part1.empty())
    return part2;
  if (part2.empty())
    return part1;
  const typename TStr::value_type lastChar1 = part1[part1.length() - 1], firstChar2 = part2[0];
  if (lastChar1 != '/' && firstChar2 != '/')
    {
      TStr res = part1;
      res += '/';
      res += part2;
      return res;
    }
  if ((lastChar1 == '/' && firstChar2 != '/') || (lastChar1 != '/' && firstChar2 == '/'))
    return part1 + part2;
  assert(lastChar1 == '/' && firstChar2 == '/');
  TStr res = part1;
  res.resize(res.length() - 1);
  res += part2;
  return part1;
}

template<class TStr>
void removeNewLineChars(TStr& str)
{
  typename TStr::size_type offset = 0;
  for(typename TStr::size_type i = 0;i < str.length();i++)
    {
      if (str[i] == '\n' || str[i] == '\r')
	{
	  offset++;
	  continue;
	}
      assert(offset <= i);
      if (offset > 0)
	str[i - offset] = str[i];
    }
  assert(offset <= str.length());
  str.resize(str.size() - offset);
}

template<class TStr>
bool stringBegins(const TStr& str, const TStr& headToCheck, TStr& tail)
{
  if (str.length() < headToCheck.length())
    return 0;
  typename TStr::size_type i;
  for(i = 0;i < headToCheck.size();i++)
    if (str[i] != headToCheck[i])
      return 0;
  //now copying left characters to tail parameter;
  tail.clear();
  while(i < str.length())
    tail += str[i++];
  return 1;
}

template<class T>
T trim(const T& str)
{
  //FIXME:Optimization;
  typename T::size_type l1=0, l2 = str.length();
  while(l1 < str.length() && BLANK_CHAR(str[l1]))
    l1++;
  while(l2 > l1 && BLANK_CHAR(str[l2-1]))
    l2--;
  T newStr;
  for(typename T::size_type i = l1;i < l2;i++)
    newStr += str[i];
  return newStr;
}

template<class T>
T toUpper(const T& str)
{
  typename T::size_type i;
  T s=str;
  for(i = 0;i < s.length();i++)
    if (s[i] >= 'a' && s[i] <= 'z')
      s[i] = 'A' + (s[i] - 'a');
  return s;
}

template<class T>
T toLower(const T& str)
{
  typename T::size_type i;
  T s = str;
  for(i = 0;i < s.length();i++)
    if (s[i] >= 'A' && s[i] <= 'Z')
      s[i] = 'a'+(s[i] - 'A');
  return s;
}

template<class T>
bool contains(const T& str, const T& s)
{
  typename T::size_type i;
  for(i = 0;i < str.length();i++)
    {
      typename T::size_type j;
      for(j = 0;j < s.length();j++)
	if (str[i] == s[j])
	  return 1;
    }
  return 0;
}

template<class T>
T adjust(const char* str)
{
  assert(str!=NULL);
  T s;
  for(size_t i = 0;str[i] != '\0';i++)
    s += str[i];
  return s;
}

template<class T>
bool checkTypeBool(const T& s)
{
  T ss = trim(toLower(s));
  if (ss == adjust<T>("yes") ||
      ss == adjust<T>("no") ||
      ss == adjust<T>("true") ||
      ss == adjust<T>("false") ||
      ss == adjust<T>("0") ||
      ss == adjust<T>("1"))
    return 1;
  return 0;
}

template<class T>
bool checkTypeUnsignedInt(const T& s)
{
  T ss = trim(s);
  if (ss.empty())
    return 0;
  typename T::size_type i = 0;
  if (ss[0] == '+')
    i=1;
  if (i >= ss.length())
    return 0;
  for(;i < ss.length();i++)
    if (ss[i] < '0' || ss[i] > '9')
      return 0;
  return 1;
}

template<class T>
bool checkTypeInt(const T& s)
{
  T ss = trim(s);
  if (ss.empty())
    return 0;
  typename T::size_type i = 0;
  if (ss[0] == '+' || ss[0] == '-')
    i=1;
  if (i >= ss.length())
    return 0;
  for(;i < ss.length();i++)
    if (ss[i] < '0' || ss[i] > '9')
      return 0;
  return 1;
}

template<class T>
bool parseAsBool(const T& s)
{
  T ss = trim(toLower(s));
  if (ss == adjust<T>("true") || ss == adjust<T>("yes") || ss == adjust<T>("1"))
    return 1;
  if (ss == adjust<T>("false") || ss == adjust<T>("no") || ss ==  adjust<T>("0"))
    return 0;
  assert(0);
  return 0;
}

template<class T>
unsigned int parseAsUnsignedInt(const T& s)
{
  T ss = trim(s);
  assert(!ss.empty());
  assert(checkTypeUnsignedInt(ss));
  unsigned int n = 0;
  typename T::size_type i=0;
  if (ss[0] == '+')
    i = 1;
  assert(i<ss.length());
  for(;i < ss.length();i++)
    {
      assert(ss[i] >= '0' || ss[i] <= '9');
      n *= 10;
      n += ss[i] - '0';
    }
  return n;
}

template<class T>
int parseAsInt(const T& s)
{
  T ss = trim(s);
  assert(!ss.empty());
  assert(checkTypeInt(ss));
  int n = 0;
  typename T::size_type i = 0;
  bool b = 0;
  if (ss[0] == '-')
    {
      b = 1;
      i = 1;
    } else
      if (ss[0] == '+')
	i = 1;
  assert(i < ss.length());
  for(;i < ss.length();i++)
    {
      assert(ss[i] >= '0' && ss[i] <= '9');
      n *= 10;
      n += s[i]-'0';
    }
  if (b)
    n *= -1;
  return n;
}

template<class T>
bool checkTypeDouble(const T& s)
{
  T ss = trim(s);
  int state=0;
  for(typename T::size_type i = 0;i < ss.length();i++)
    {
      if (state == 0 && (ss[i] == '-' || ss[i] == '+' || (ss[i] >= '0' && ss[i] <= '9')))
	{
	  state = 1;
	  continue;
	}
      if (state == 1 && ss[i] >= '0' && ss[i] <= '9')
	continue;
      if (state == 1 && ss[i] == '.')
	{
	  state=2;
	  continue;
	}
      if (state == 2 && ss[i] >= '0' && ss[i] <= '9')
	{
	  state = 3;
	  continue;
	}
      if (state == 3 && ss[i] >= '0' && ss[i] <= '9')
	continue;
      return 0;
    }// for();
  return (state==1 || state==3);
}

template<class T>
double parseAsDouble(const T& s)
{
  assert(checkTypeDouble(s));
  T s1, s2, ss = trim(s);
  bool b = 0, sign = 0;
  typename T::size_type i;
  for(i = 0;i < ss.length();i++)
    {
      if (ss[i] == '.')
	{
	  b = 1;
	  continue;
	}
      if (ss[i] == '-')
	{
	  sign=1;
	  continue;
	}
      if (ss[i] < '0' || ss[i] > '9')
	continue;
      if (!b)
	s1 += ss[i];else 
	  s2 += ss[i];
    }
  assert(!s1.empty());
  double d1 = 0, d2 = 0;
  for(i = 0;i < s1.length();i++)
    {
      d1 *= 10;
      d1 += s1[i]-'0';
    }
  if (!s2.empty())
    {
      typename T::size_type z = s2.length() - 1;
      while(z >= 0 && s2[z] == '0') z--;
      if (z >= 0)
	{
	  for(i = 0;i <= z;i++)
	    {
	      d2 *= 10;
	      d2 += s2[i]-'0';
	    }
	  for(i = 0;i <= z;i++)
	    d2 /= 10;
	}
    }
  d1 += d2;
  if (sign)
    d1*= -1;
  return d1;
}

template<class T>
T makeStringFromDouble(double value, typename T::size_type format)
{
  assert(format >= 0 && format <= 10);
  double ff = value;
  typename T::size_type i;
  for(i = format;i > 0;i--)
    ff *= 10;
  long c = (long)ff;
  bool sign = c < 0;
  if (sign)
    c *= -1;
  std::ostringstream ss;
  ss << c;
  T s = adjust<T>(ss.str().c_str());
  while(s.length() < format + 1)
    s = '0' + s;
  if (sign)
    s = '-' + s;
  if (format == 0)
    return s;
  assert(s.length() > format);
  typename T::size_type dotPosition = s.length() - format;//here was -1;
  s += ' ';
  for(typename T::size_type si = s.length() - 1;si >= dotPosition + 1;si--)
    s[si] = s[si - 1];
  s[dotPosition] = '.';
  return s;
}

template<class T>
void attachSpace(T& str)
{
  if (str.empty())
    return;
  if (BLANK_CHAR(str[str.length() - 1]))
    return;
  str += ' ';
}

template<class T>
void attachString(T& str, const T& toAttach)
{
  if (trim(str).empty())
    {
      str = trim(toAttach);
      return;
    }
  if (BLANK_CHAR(str[str.length() - 1]))
    {
      str += trim(toAttach);
      return;
    }
  str += ' ';
  str += trim(toAttach);
}

template<class T>
void attachCharWithoutDoubleSpaces(T& str, typename T::value_type ch)
{
  if (!BLANK_CHAR(ch))
    {
      str += ch;
      return;
    }
  if (BLANK_CHAR(str[str.length() - 1]))
    return;
  str += ' ';
}

template<class T>
void attachStringWithSpace(T& str, const T& toAttach)
{
  str += trim(toAttach);
  str += ' ';
}

template<class T>
void attachCharWithSpace(T& str, typename T::value_type ch)
{
  if (!BLANK_CHAR(ch))
    str += ch;
  str += ' ';
}

template<typename T>
T getDelimitedSubStr(const T& s, size_t index, char delimiter)
{
  assert(index >= 0);
  T ss = trim(s);
  typename T::size_type i;
  size_t k = 0;
  for(i = 0;i < ss.length() && k < index;i++)
    if (ss[i] == delimiter)
      k++;
  if (i >= ss.length())
    return T();
  T s1;
  for(;i < ss.length() && ss[i] != delimiter;i++)
    s1 += ss[i];
  return s1;
}

/*KILLME:
namespace __gnu_cxx
{
  template<> struct hash<wchar_t>
  {
    size_t operator()(wchar_t x) const
    {
      return hash< size_t>()(x);
    }
  };
} //namespace __gnu_cxx;
*/

template<class T>
class StringIterator 
{
public:
  typedef typename T::value_type CHAR;

  StringIterator(const T& str, const T& chars)
    : m_str(str), m_start(0), m_end(0)
  {
    assert(!chars.empty());
    for(typename T::size_type i = 0;i < chars.length();i++)
      m_chars.insert(chars[i]);
  }

    bool match(CHAR c) const
  {
    return m_chars.find(c) != m_chars.end();
  }

  bool next()
  {
    assert(m_start <= m_end);
    if (m_start < m_end)//it is not a first iteration;
      m_start = m_end + 1;
    if (m_start >= m_str.length())
      return 0;
    while(m_start < m_str.length() && !match(m_str[m_start])) 
      m_start++;
    if (m_start >= m_str.length())
      return 0;
    m_end = m_start;
    while(m_end < m_str.length() && match(m_str[m_end])) 
      m_end++;
    assert(m_start < m_end);
    return 1;
  }

  T str() const
  {
    assert(m_start >= 0 && m_end <= m_str.length() && m_start < m_end);
    T s;
    for(typename T::size_type i = m_start;i < m_end;i++)
      s += m_str[i];
    return s;
  }

  typename T::size_type start() const 
  { 
    assert(m_start >= 0 && m_end <= m_str.length() && m_start < m_end); 
    return m_start; 
  }

  typename T::size_type end() const 
  { 
    assert(m_start >= 0 && m_end <= m_str.length() && m_start < m_end); 
    return m_end; 
  }

private:
  const T& m_str;
  std::set<CHAR> m_chars;
  typename T::size_type m_start;
  typename T::size_type m_end;
};//class StringIterator;

template<class T>
class StringDelimitedIterator 
{
public:
  typedef typename T::value_type CHAR;

  StringDelimitedIterator(const T& str, const T& chars)
    : m_start(0), m_str(str), m_end(0)
  {
    assert(!chars.empty());
    for(typename T::size_type i = 0;i < chars.length();i++)
      m_chars.insert(chars[i]);
  }

    bool match(CHAR c) const
  {
    return m_chars.find(c) == m_chars.end();
  }

  bool next()
  {
    assert(m_start <= m_end);
    if (m_start < m_end)//it is not a first iteration;
      m_start = m_end + 1;
    if (m_start >= m_str.length())
      return 0;
    while(m_start < m_str.length() && !match(m_str[m_start])) 
      m_start++;
    if (m_start >= m_str.length())
      return 0;
    m_end = m_start;
    while(m_end < m_str.length() && match(m_str[m_end])) 
      m_end++;
    assert(m_start < m_end);
    return 1;
  }

  T str() const
  {
    assert(m_start >= 0 && m_end <= m_str.length() && m_start < m_end);
    T s;
    for(typename T::size_type i = m_start;i < m_end;i++)
      s += m_str[i];
    return s;
  }

  typename T::size_type start() const 
  { 
    assert(m_start >= 0 && m_end <= m_str.length() && m_start < m_end); 
    return m_start; 
  }

  typename T::size_type end() const 
  { 
    assert(m_start >= 0 && m_end <= m_str.length() && m_start < m_end); 
    return m_end; 
  }

private:
  const T& m_str;
  std::set<CHAR> m_chars;
  typename T::size_type m_start;
  typename T::size_type m_end;
};//class StringDelimitedIterator;

template<class TStr>
class TextQueue
{
 public:
  TextQueue() {}

  TextQueue(const TStr& initialValue)
    : m_chain(initialValue) {}

  bool next(TStr& line)
  {
    TStr s1, s2;
    bool wasNewLine = 0;
    for(typename TStr::size_type i = 0;i < m_chain.length();i++)
      {
	if (m_chain[i] == '\r')
	  continue;
	if (m_chain[i] == '\n')
	  {
	    wasNewLine = 1;
	    continue;
	  }
	if (!wasNewLine)
	  s1 += m_chain[i]; else 
	  s2 += m_chain[i];
      } //for();
    if (!wasNewLine)
      return 0;
    line = s1;
    m_chain = s2;
    return 1;
  }

  TStr chain() const
  {
    return m_chain;
  }

private:
  TStr m_chain;
}; //class TextQueue;

#endif //__VOICEMAN_STRINGS_H__
