

#ifndef __VOICEMAN_EMACSPEAK_CONNECTION_H__
#define 

class Connection
{
public:
  Connection() 
    : m_con(VOICEMAN_BAD_CONNECTION) {}

  virtual ~Connection() {}

  /**\brief Sends the text to voicemand to speak
   *
   * This function checks the connection to voicemand.
   * If a connection was not established, it tries to connect. If new attempt 
   * fails, this function do nothing silently or transmits the text data otherwise.
   *
   * \param [in] t The text to send
   */
  void text(const std::string& t);

  /**\brief Sends a letter command to daemon
   *
   * This function checks the connection to voicemand.
   * If a connection was not established, it tries to connect. If new attempt 
   * fails, this function do nothing silently or transmits the text data otherwise.
   *( \param l The letter bytes
   */
  void letter(const std::string& l);

  /**\brief Stops any speech playback on speech server
   *
   * This function checks the connection like text() or letter() functions
   */
  void stop();

  /**\brief Sens a tone command to voiceman daemon
   *
   * This function checks connection like text() or letter() functions.
   *
   * \param freq The desired frequency of a command to send
   * \param [in] lenthMs The desired length of a command to send
   */
  void tone(int freq, int lengthMs);

private:
  /**\brief The current connection to voicemand*/
  vm_connection_t m_con;
}; //class Connection;

#endif //__VOICEMAN_EMACSPEAK_CONNECTION_H__;
