
#ifndef __VOICEMAN_VMCLIENT_H__
#define __VOICEMAN_VMCLIENT_H__

#ifdef __cplusplus 
#define EXTC extern "C"
#else
#define EXTC extern
#endif /* __cplusplus*/

#define VOICEMAN_LANG_NONE 0
#define VOICEMAN_LANG_ENG 1
#define VOICEMAN_LANG_RUS 2

#define VOICEMAN_PROCMODE_ALL 0
#define VOICEMAN_PROCMODE_SOME 1
#define VOICEMAN_PROCMODE_NONE 2

typedef int vm_connection_t;
#define VOICEMAN_BAD_CONNECTION (vm_connection_t)-1

typedef int vm_result_t;
#define VOICEMAN_ERROR (vm_result_t)-1
#define VOICEMAN_OK 0

EXTC vm_connection_t vm_connect();
EXTC vm_connection_t vm_connect_unix(char* path);
EXTC vm_connection_t vm_connect_inet(char* host, size_t port);
EXTC void vm_close(vm_connection_t con);
EXTC vm_result_t vm_text(vm_connection_t con, char* text); 
EXTC vm_result_t vm_stop(vm_connection_t con);
EXTC vm_result_t vm_letter(vm_connection_t con, char* letter);
EXTC vm_result_t vm_tone(vm_connection_t con, size_t freq, size_t lengthms);
EXTC vm_result_t vm_pitch(vm_connection_t con, size_t value);
EXTC vm_result_t vm_rate(vm_connection_t con, size_t value);
EXTC vm_result_t vm_volume(vm_connection_t con, size_t value);
EXTC vm_result_t vm_procmode(vm_connection_t con, unsigned char procmode);
EXTC vm_result_t vm_family(vm_connection_t con, unsigned char lang, char* family);

#endif /*__VOICEMAN_VMCLIENT_H__*/
