
#include"voiceman.h"
#include"DelimitedFile.h"

void DelimitedFile::read(const std::string& fileName)
{
  logMsg(LOG_DEBUG, "Reading delimited file \'%s\'", fileName.c_str());
  std::string s;
  m_lines.clear();
  s = readTextFile(fileName);
  s = cutComments(s);
  s += '\n';
  std::string ss;
  for(std::string::size_type i = 0;i < s.length();i++)
    {
      if (s[i] == '\r')
	continue;
      if (s[i] == '\n')
	{
	  ss = trim(ss);
	  if (!ss.empty())
	    m_lines.push_back(ss);
	  ss.erase();
	  continue;
	} // if '\n';
      ss+= s[i];
    } // for;
  logMsg(LOG_DEBUG, "Read %u delimited lines", m_lines.size());
}

size_t DelimitedFile::getItemCountInLine(size_t line) const
{
  assert(line < m_lines.size());
  const std::string& s=m_lines[line];
  size_t k = 0;
  for(std::string::size_type i = 0;i < s.length();i++)
    if (s[i] == ':')
      k++;
  return k + 1;
}

std::string DelimitedFile::getItem(size_t line, size_t itemIndex) const
{
  assert(line < m_lines.size());
  return getDelimitedSubStr(m_lines[line], itemIndex, ':');
}

size_t DelimitedFile::getLineCount() const
{
  return m_lines.size();
}

std::string DelimitedFile::getRawLine(size_t index) const
{
  assert(index <= m_lines.size());
  return m_lines[index];
}
