
#ifndef __VOICEMAN_EMACSPEAK_LINE_PARSER_H__
#define __VOICEMAN_EMACSPEAK_LINE_PARSER_H__

#include"Connection.h"

class TextItem
{
public:
  TextItem(const std::string& t, size_t p, size_t r, size_t v)
    : text(t), pitch(p), rate(r), volume(v) {}

  bool equalParamsTo(const TextItem& item) const
  {
    if (item.pitch != pitch)
      return 0;
    if (item.rate != rate)
      return 0;
    if (item.volume != volume)
      return 0;
    return 1;
  }

public:
  std::string text;
  size_t pitch;
  size_t rate;
  size_t volume;
}; //class TextItem;

typedef std::vector<TextItem> TextItemVector;
typedef std::list<TextItem> TextItemList;

class LineParser
{
public:
  LineParser()
    : m_pitch(50), m_rate(50), m_volume(50)  {}

  virtual ~LineParser() {}

  void  processCommand(const std::string& command, const StringVector& parameters);

private:
  void processDectalkCommand(const std::string& s);
  void processDectalkDefineVoice(StringDelimitedIterator<std::string>& it);

  void q(const std::string& s);
  void d();
  void s();
  void l(const std::string& s);
  void tts_say(const std::string& s);
  void tts_set_speech_rate(const std::string& s);
  void t(const StringVector& s);
  void tts_set_punctuations(const std::string& s);
  void tts_sync_state(const StringVector& s);

private:
  Connection m_connection;
  TextItemList m_items;
  size_t m_pitch, m_rate, m_volume;
}; //class LineParser;

#endif //__VOICEMAN_EMACSPEAK_LINE_PARSER_H__;
