#!/bin/sh

PASSES=0
FAILS=0

compare_files() {
	if [ $# -ne 2 ]; then
		echo "error"
		return 1
	fi
	
	ORIG=$1
	MODIF=$2
	
	cmp -s $ORIG $MODIF
	if  [ $? -ne 0 ]; then
		FAILS=$[FAILS+1]
		printf '\033[31mfailed\033[0m\n'
		diff -u $ORIG $MODIF
	else
		PASSES=$[PASSES+1]
		printf '\033[32mok\033[0m\n'
		rm -f $MODIF
	fi
}

do_test() {
	if [ $# -ne 2 ]; then
		echo "$FUNC: insufficient arguments!" >&2
		return 1
	fi
	
	NO=$1
	MSG="$2"
	TESTNO=`printf '%03d\n' $NO`
	
	printf '%3d Test %s... ' "$NO" "$MSG"
	
	compare_files ${TESTNO}.ok ${TESTNO}.out
}

TOP=../src
HLINT=$TOP/hlint

$HLINT >001.out 2>&1
do_test 1 "without arguments"

$HLINT 002.ok 002.ok >002.out 2>&1
do_test 2 "with two files in command line"

$HLINT 003.in >003.out 2>&1
do_test 3 "when main file not exist"

$HLINT 004.in >004.out 2>&1
do_test 4 "with empty source file"

$HLINT 005.in >005.out 2>&1
do_test 5 "system headers detection"

$HLINT -n 006.in >006.out 2>&1
do_test 6 "system header detection with -n flag"

$HLINT 007.in >007.out 2>&1
do_test 7 "user header detection"

$HLINT -r 008.in >008.out 2>&1
do_test 8 "user header with -r flag"

$HLINT -r 009.in >009.out 2>&1
do_test 9 "not exist user header with -r flag"

$HLINT -r 010/010.in >010.out 2>&1
do_test 10 "when source file in another directory and -r flag specified"

$HLINT -r 011.in >011.out 2>&1
do_test 11 "when we have two similar users headers and can't open second"

$HLINT -r -n >012.out 2>&1
do_test 12 "when user specified only options without file name"

$HLINT -X >013.out 2>&1
do_test 13 "when user specified unknown option"

$HLINT -rn 014.in >014.out 2>&1
do_test 14 "for works combined options"

$HLINT -r 015.in >015.out 2>&1
do_test 15 "detection of duplicate headers"

echo
printf '    Tests passes:\t%2d\n' $PASSES
printf '    Tests failures:\t%2d\n' $FAILS
echo

