/*
 * Copyright (C) 2007 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef LINEOFSOURCECODE_HH
#define LINEOFSOURCECODE_HH

#include "SourceFile.hh"	// for SourceFile class

enum LineType {
	CODE,		// line contains code
#ifdef FEATURE
	BLANK,		// line is empty
#endif
	USRHDR,		// line contains #include "..." directive
	SYSHDR,		// line contsins #include <...> directive
#ifndef FEATURE
	UNKHDR		// line is one of unsupported directives
#else
	UNKHDR,		// line is one of unsupported directives
	IFDEF,		// line is #ifdef directive
	IFNDEF,		// line is #ifndef directive
	ENDIF		// line is #endif directive
#endif
};

class LineOfSourceCode {
public:
	LineOfSourceCode(std::string line, size_t lineNumber);
	~LineOfSourceCode();

#ifdef FEATURE
	bool isDirective() const		{return (type != CODE && type != BLANK);}
	bool isBlank() const			{return type == BLANK;}
#endif

	bool isUserInclude() const		{return type == USRHDR;}
	bool isSystemInclude() const	{return type == SYSHDR;}

#ifdef FEATURE
	bool isIfdef() const			{return type == IFDEF;}
	bool isIfndef() const			{return type == IFNDEF;}
	bool isEndif() const			{return type == ENDIF;}
#endif

	const std::string &getHeaderName() const {return headerName;}
	size_t getLineNumber() const {return lineno;}

private:
	const char *_isDirective(const char *str) const;
	const char *_detectDirective(const char *str, const char *directiveName) const;

	bool _isHeader(const char *str, char begin = '<', char end = '>') const;

#ifdef FEATURE
	std::string sourceLine;	// content of line
#endif
	size_t lineno;			// number of line
	enum LineType type;		// type of line
	std::string headerName;	// used only for headers for saving their names

	friend SourceFile::SourceFile(const char *, bool, bool);
	friend void SourceFile::printHeaderNames(bool, size_t, bool) const;
	SourceFile *usf;	// used for get access to content of user header
};

#endif // !LINEOFSOURCECODE_HH

