/*
 * Copyright (C) 2007 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef SOURCEFILE_HH
#define SOURCEFILE_HH

#include <iostream>	// for ostream class
#include <list>		// for list class
#include <map>		// for multimap class
#include <string>	// for string class

class LineOfSourceCode;

class SourceFile {
public:
	SourceFile(const char *filename, bool rflag, bool pheader = true);
	~SourceFile();

	void printHeaderNames(bool printLineNumbers, size_t level = 1, bool pheader = true) const;
	bool fileExist() const {return fileWasOpened;}

private:
	std::list<LineOfSourceCode *> sourceFile;
	std::string fileName;
	bool recursive_mode;
	bool printHeader;
	bool fileWasOpened;

	// Needed for detection duplicate headers.
	// Works only for main file (when printHeader is true).
	inline void addHeader(LineOfSourceCode *losc);
	void printDuplicateHeaders(const std::string &name, size_t lineno,
											std::ostream &os) const;
	std::multimap<std::string, LineOfSourceCode *> hdb;
};

#endif // !SOURCEFILE_HH

