/*
 * Copyright (C) 2007 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include <cstdlib>	// for EXIT_* constant

#include "SourceFile.hh"	// for SourceFile class

using std::cerr;
using std::endl;

int main(int argc, char *argv[]) {

	bool rflag = false;
	bool nflag = false;

	bool fileSpecified = false;
	int index = 0;

	if (argc < 2) {
		cerr << "Usage: hlint [-rn] file" << endl;
		return EXIT_FAILURE;

	// The reason of why we not uses getopt() here is because Windows doesn't
	// have this function
	} else {
		for (int i = 1; i < argc; ++i) {
			if (argv[i][0] == '-') {

				for (int j = 1; argv[i][j] != '\0'; ++j) {
					switch (argv[i][j]) {
						case 'r':
							rflag = true;
							break;

						case 'n':
							nflag = true;
							break;

						default:
							cerr << "Unknown option: -" << argv[i][j] << endl;
							return EXIT_FAILURE;
					}
				}

			} else {
				if (fileSpecified) {
					cerr << "Only one file should be specified!" << endl;
					return EXIT_FAILURE;
				}
				index = i;
				fileSpecified = true;
			}
		}
	}

	if (index == 0) {
	    cerr << "You should specify source file!" << endl;
	    return EXIT_FAILURE;
	}


	SourceFile sf(argv[index], rflag);
	sf.printHeaderNames(nflag);

	return EXIT_SUCCESS;
}
