/*
 * Copyright (C) 2007-2008 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef LINEOFSOURCECODE_HH
#define LINEOFSOURCECODE_HH

#include "SourceFile.hh"	// for {Di,Indi}rectSourceFile classes

enum LineType {
	CODE,		// line contains code
#ifdef FEATURE
	BLANK,		// line is empty
#endif
	USRHDR,		// line contains #include "..." directive
	SYSHDR,		// line contsins #include <...> directive
#ifndef FEATURE
	UNKHDR		// line is one of unsupported directives
#else
	UNKHDR,		// line is one of unsupported directives
	IFDEF,		// line is #ifdef directive
	IFNDEF,		// line is #ifndef directive
	ENDIF		// line is #endif directive
#endif
};

enum LineStatus {
	NOTCHANGED,	// normal line (default state)
#ifdef FEATURE
	ADDED,		// line was added
#endif
	DELETED		// line should be deleted
};

class LineOfSourceCode {
public:
	LineOfSourceCode(std::string line, size_t lineNumber);
	~LineOfSourceCode();

#ifdef FEATURE
	bool isDirective() const		{return (type != CODE && type != BLANK);}
	bool isBlank() const			{return type == BLANK;}
#endif

	bool isUserInclude() const		{return type == USRHDR;}
	bool isSystemInclude() const	{return type == SYSHDR;}
	bool isInclude() const			{return type == SYSHDR || type == USRHDR;}

#ifdef FEATURE
	bool isIfdef() const			{return type == IFDEF;}
	bool isIfndef() const			{return type == IFNDEF;}
	bool isEndif() const			{return type == ENDIF;}
#endif

	const std::string &getHeaderName() const {return headerName;}
	size_t getLineNumber() const {return lineno;}

	// Uses only for patch producing
	LineStatus getStatus() const	{return status;}
	void setStatus(enum LineStatus st)	{status = st;}
	// TODO: use overloading operator
	const std::string &toString() const {return sourceLine;}

private:
	const char *_isDirective(const char *str) const;
	const char *_detectDirective(const char *str, const char *directiveName) const;
	
	bool _isHeader(const char *str, char begin = '<', char end = '>') const;

	std::string sourceLine;	// content of line (used only for patch producing)
	size_t lineno;			// number of line
	enum LineType type;		// type of line
	enum LineStatus status;	// line status (used only for patch producing)
	std::string headerName;	// used only for headers for saving their names

	friend DirectSourceFile::DirectSourceFile(const std::string &, bool);
	friend IndirectSourceFile::IndirectSourceFile(const std::string &);
	friend void DirectSourceFile::printHeaderTree(bool, size_t) const;
	friend void IndirectSourceFile::printHeaderTree(bool, size_t) const;
	IndirectSourceFile *usf;	// used for get access to content of user header
};

#endif // !LINEOFSOURCECODE_HH

