/*
 * Copyright (C) 2007-2008 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef SOURCEFILE_HH
#define SOURCEFILE_HH

#include <iostream>
#include <map>		// for multimap class
#include <string>	// for string class
#include <vector>	// for vector class

class LineOfSourceCode;


class BaseSourceFile {
public:
	explicit BaseSourceFile(const std::string &filename);
	virtual ~BaseSourceFile();
	virtual void printHeaderTree(bool nflag, size_t level = 1) const = 0;

	int parseSourceFile(const std::string &filename);

protected:
	std::vector<LineOfSourceCode *> sourceFile;	// source file line by line
	std::vector<LineOfSourceCode *> headers;	// only lines with #include directive
	std::string fileName;
	std::string filePath;
};


class DirectSourceFile : public BaseSourceFile {
public:
	DirectSourceFile(const std::string &filename, bool recursive);
	void printHeaderTree(bool nflag, size_t level = 1) const;
	void producePatch();

private:
	// Needed for detection duplicate headers.
	inline void addHeader(LineOfSourceCode *losc);
	void printDuplicateHeaders(const std::string &name, size_t lineno) const;

	std::multimap<std::string, LineOfSourceCode *> hdb;
	bool rflag;
};


class IndirectSourceFile : BaseSourceFile {
public:
	explicit IndirectSourceFile(const std::string &filename);
	void printHeaderTree(bool nflag, size_t level = 1) const;
	bool fileExist() const {return fileWasOpened;}

private:
	bool fileWasOpened;
};

#endif // !SOURCEFILE_HH

