/*
 * Copyright (C) 2007-2008 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "SourceFile.hh"	// for DirectSourceFile class

#include <cassert>	// for assert()
#include <cstdlib>	// for EXIT_* constant


using std::cerr;
using std::endl;
using std::string;

int main(int argc, char *argv[]) {

	bool nflag = false;	// print line numbers
	bool pflag = false;	// produce patch
	bool rflag = false;	// recursive mode

	int index = 0;

	if (argc < 2) {
		cerr << "Usage: hlint [-rn|-p] file" << endl;
		return EXIT_FAILURE;
	}

	// The reason of why we not uses getopt() here is because Windows doesn't
	// have this function
	for (int i = 1; i < argc; ++i) {
		if (argv[i][0] == '-') {
			
			for (int j = 1; argv[i][j] != '\0'; ++j) {
				switch (argv[i][j]) {
					
					case 'n':
						nflag = true;
						break;
					
					case 'p':
						pflag = true;
						break;
					
					case 'r':
						rflag = true;
						break;
					
					default:
						cerr << "Unknown option: -" << argv[i][j] << endl;
						return EXIT_FAILURE;
				}
			}
		
		} else {
			if (index != 0) {
				cerr << "Only one file should be specified!" << endl;
				return EXIT_FAILURE;
			}
			index = i;
		}
	}
	
	if (index == 0) {
	    cerr << "You should specify source file!" << endl;
	    return EXIT_FAILURE;
	}
	
	if (pflag && (rflag || nflag)) {
		cerr << "Option -p conflicts with -r and -n options!" << endl;
		return EXIT_FAILURE;
	}
	
	
	DirectSourceFile sf(string(argv[index]), rflag);
	
	if (pflag) {
		
		// -p option conflicts with -r and -n and program should was
		// exit if they was mixed together
		assert(pflag == true && rflag == false);
		assert(pflag == true && nflag == false);
		
		sf.producePatch();
	} else {
		sf.printHeaderTree(nflag);
	}
	
	return EXIT_SUCCESS;
}
