/*
 * Copyright (C) 2007-2009 Slava Semushin <php-coder@altlinux.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/**
 * @class DirectSourceFile
 * File with source code which user explicitly give to program.
 **/

#ifndef DIRECTSOURCEFILE_HH
#define DIRECTSOURCEFILE_HH

#include "SourceFile.hh"
#include "Algorithm.hh"	// for DrtvPair pair

#include <map>	// for map class
#include <set>	// for set class

class DirectiveWithCondition;

class DirectSourceFile : public SourceFile {
public:
	DirectSourceFile(const std::string &filename, bool recursive);
	virtual void printHeaderTree(bool nflag, size_t level = 1) const;
	void producePatch(bool print_banner = true) const;
	
private:
	// Needed for patch creation
	void markDuplicates(std::set<size_t> &deleted_lines_list) const;
	bool markLinesAroundDuplicates(std::set<size_t> &deleted_lines_list) const;
	void markLinesAroundDuplicatesRecursively(std::set<size_t> &deleted_lines_list) const;
	void markEmptyLinesBetweenAlreadyRemovedLines(std::set<size_t> &deleted_lines_list) const;
	void invertIfdefsWithEmptyBody(std::set<size_t> &deleted_lines_list,
			std::set<size_t> &added_lines_list,
			std::map<size_t, size_t> &replaced_lines) const;
	
	static bool isDeletedLine(const std::set<size_t> &deleted_lines_list, size_t lineno) {
		// set.count() return 1 if element exists in set or 0
		return (deleted_lines_list.count(lineno) ? true : false);
	};
	
	bool rflag;
	std::vector<Algorithm::DrtvPair> condition_pairs;
};

#endif // !DIRECTSOURCEFILE_HH

